/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import cloud.lemonslice.teastory.block.HorizontalConnectedBlock;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import xueluoanping.teastory.variant.Planks;

public class TrellisBlock
extends HorizontalConnectedBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty POST = BooleanProperty.m_61465_((String)"post");
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    private static final VoxelShape[] SHAPES;
    public static final BooleanProperty WATERLOGGED;

    public TrellisBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        return this.getProperState(world, pos);
    }

    public boolean hasHorizontalBar(BlockState state) {
        return (Boolean)state.m_61143_((Property)NORTH) != false || (Boolean)state.m_61143_((Property)SOUTH) != false || (Boolean)state.m_61143_((Property)WEST) != false || (Boolean)state.m_61143_((Property)EAST) != false;
    }

    public boolean hasPost(BlockState state) {
        return (Boolean)state.m_61143_((Property)POST);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int north = (Boolean)state.m_61143_((Property)NORTH) != false ? 32 : 0;
        int south = (Boolean)state.m_61143_((Property)SOUTH) != false ? 16 : 0;
        int east = (Boolean)state.m_61143_((Property)WEST) != false ? 8 : 0;
        int west = (Boolean)state.m_61143_((Property)EAST) != false ? 4 : 0;
        int up = (Boolean)state.m_61143_((Property)UP) != false ? 2 : 0;
        int post = this.hasPost(state) ? 1 : 0;
        return SHAPES[north + south + east + west + post + up];
    }

    public BlockState getProperState(Level world, BlockPos pos) {
        BlockState up;
        BlockState state = this.m_49966_();
        BlockState belowState = world.m_8055_(pos.m_7495_());
        if (belowState.m_60734_() instanceof TrellisBlock || belowState.m_204336_(BlockTags.f_13098_) || belowState.m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP)) {
            state = (BlockState)state.m_61124_((Property)POST, (Comparable)Boolean.valueOf(true));
        }
        if ((up = world.m_8055_(pos.m_7494_())).m_60734_() instanceof TrellisBlock || up.m_204336_(BlockTags.f_13098_) || up.m_60783_((BlockGetter)world, pos.m_7494_(), Direction.DOWN)) {
            state = (BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(true));
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos facingPos = pos.m_121945_(facing);
            BlockState facingState = world.m_8055_(facingPos);
            if (!this.canConnect(facingState, facingState.m_60783_((BlockGetter)world, facingPos, facing.m_122424_()))) continue;
            state = (BlockState)state.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean canConnect(BlockState state, boolean isSolidSide) {
        Block block = state.m_60734_();
        return !TrellisBlock.m_152463_((BlockState)state) && isSolidSide || block instanceof TrellisBlock;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            stateIn = (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canConnect(facingState, facingState.m_60783_((BlockGetter)worldIn, facingPos, facing.m_122424_()))));
        } else if (facing == Direction.DOWN) {
            BlockPos posDown = currentPos.m_121945_(facing);
            BlockState state = worldIn.m_8055_(posDown);
            stateIn = (BlockState)stateIn.m_61124_((Property)POST, (Comparable)Boolean.valueOf(state.m_60734_() instanceof TrellisBlock || state.m_204336_(BlockTags.f_13098_) || state.m_60783_((BlockGetter)worldIn, posDown, Direction.UP)));
        } else if (facing == Direction.UP) {
            BlockPos posUp = currentPos.m_121945_(facing);
            BlockState state = worldIn.m_8055_(posUp);
            stateIn = (BlockState)stateIn.m_61124_((Property)UP, (Comparable)Boolean.valueOf(state.m_60734_() instanceof TrellisBlock || state.m_204336_(BlockTags.f_13098_) || state.m_60783_((BlockGetter)worldIn, posUp, Direction.DOWN)));
        }
        return stateIn;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{POST, UP, WATERLOGGED}));
    }

    public BlockState getRelevantState(BlockState old) {
        BlockState newState = this.m_49966_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newState.m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)old.m_61143_((Property)WATERLOGGED)))).m_61124_((Property)NORTH, (Comparable)((Boolean)old.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)old.m_61143_((Property)SOUTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)old.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)old.m_61143_((Property)EAST)))).m_61124_((Property)POST, (Comparable)((Boolean)old.m_61143_((Property)POST)))).m_61124_((Property)UP, (Comparable)((Boolean)old.m_61143_((Property)UP)));
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
    }

    public MutableComponent m_49954_() {
        Planks.PlankHolders ss = Planks.TrellisBlockMap.get(BuiltInRegistries.f_256975_.m_7981_((Object)this));
        if (ss == null) {
            return super.m_49954_();
        }
        return Component.m_237115_((String)ss.plank().m_7705_()).m_7220_((Component)Component.m_237115_((String)"misc.block.teastory.trellis_suffix"));
    }

    static {
        WATERLOGGED = BlockStateProperties.f_61362_;
        VoxelShape CENTER = VoxelShapeHelper.createVoxelShape(7.0, 7.0, 7.0, 2.0, 3.0, 2.0);
        VoxelShape TOP_NORTH = VoxelShapeHelper.createVoxelShape(7.0, 7.0, 0.0, 2.0, 3.0, 14.0);
        VoxelShape TOP_SOUTH = VoxelShapeHelper.createVoxelShape(7.0, 7.0, 2.0, 2.0, 3.0, 14.0);
        VoxelShape TOP_EAST = VoxelShapeHelper.createVoxelShape(0.0, 7.0, 7.0, 14.0, 3.0, 2.0);
        VoxelShape TOP_WEST = VoxelShapeHelper.createVoxelShape(2.0, 7.0, 7.0, 14.0, 3.0, 2.0);
        VoxelShape POST_SHAPE = VoxelShapeHelper.createVoxelShape(6.0, 0.0, 6.0, 4.0, 12.0, 4.0);
        VoxelShape POST_UP_SHAPE = VoxelShapeHelper.createVoxelShape(6.0, 7.0, 6.0, 4.0, 9.0, 4.0);
        SHAPES = new VoxelShape[]{CENTER, POST_SHAPE, POST_UP_SHAPE, Shapes.m_83110_((VoxelShape)POST_UP_SHAPE, (VoxelShape)POST_SHAPE), TOP_WEST, Shapes.m_83110_((VoxelShape)TOP_WEST, (VoxelShape)POST_SHAPE), Shapes.m_83110_((VoxelShape)TOP_WEST, (VoxelShape)POST_UP_SHAPE), Shapes.m_83124_((VoxelShape)TOP_WEST, (VoxelShape[])new VoxelShape[]{POST_UP_SHAPE, POST_SHAPE}), TOP_EAST, Shapes.m_83110_((VoxelShape)TOP_EAST, (VoxelShape)POST_SHAPE), Shapes.m_83110_((VoxelShape)TOP_EAST, (VoxelShape)POST_UP_SHAPE), Shapes.m_83124_((VoxelShape)TOP_EAST, (VoxelShape[])new VoxelShape[]{POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83110_((VoxelShape)TOP_EAST, (VoxelShape)TOP_WEST), Shapes.m_83124_((VoxelShape)TOP_EAST, (VoxelShape[])new VoxelShape[]{TOP_WEST, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_EAST, (VoxelShape[])new VoxelShape[]{TOP_WEST, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_EAST, (VoxelShape[])new VoxelShape[]{TOP_WEST, POST_UP_SHAPE, POST_SHAPE}), TOP_SOUTH, Shapes.m_83110_((VoxelShape)TOP_SOUTH, (VoxelShape)POST_SHAPE), Shapes.m_83110_((VoxelShape)TOP_SOUTH, (VoxelShape)POST_UP_SHAPE), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83110_((VoxelShape)TOP_SOUTH, (VoxelShape)TOP_WEST), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{TOP_WEST, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{TOP_WEST, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{TOP_WEST, POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83110_((VoxelShape)TOP_SOUTH, (VoxelShape)TOP_EAST), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, TOP_WEST}), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, TOP_WEST, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, TOP_WEST, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_SOUTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, TOP_WEST, POST_UP_SHAPE, POST_SHAPE}), TOP_NORTH, Shapes.m_83110_((VoxelShape)TOP_NORTH, (VoxelShape)POST_SHAPE), Shapes.m_83110_((VoxelShape)TOP_NORTH, (VoxelShape)POST_UP_SHAPE), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83110_((VoxelShape)TOP_NORTH, (VoxelShape)TOP_WEST), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_WEST, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_WEST, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_WEST, POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83110_((VoxelShape)TOP_NORTH, (VoxelShape)TOP_EAST), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, TOP_WEST}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, TOP_WEST, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, TOP_WEST, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_EAST, TOP_WEST, POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83110_((VoxelShape)TOP_NORTH, (VoxelShape)TOP_SOUTH), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_WEST}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_WEST, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_WEST, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_WEST, POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_EAST}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_EAST, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_EAST, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_EAST, POST_UP_SHAPE, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_EAST, TOP_WEST}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_EAST, TOP_WEST, POST_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_EAST, TOP_WEST, POST_UP_SHAPE}), Shapes.m_83124_((VoxelShape)TOP_NORTH, (VoxelShape[])new VoxelShape[]{TOP_SOUTH, TOP_EAST, TOP_WEST, POST_UP_SHAPE, POST_SHAPE})};
    }
}

